<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">
        <i class="bi bi-pencil me-2"></i>Edit Aktivitas Harian
    </h2>
    <a href="<?= base_url('admin/activities') ?>" class="btn btn-secondary">
        <i class="bi bi-arrow-left me-1"></i>Kembali
    </a>
</div>

<?php if (session()->getFlashdata('errors')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <ul class="mb-0">
            <?php foreach (session()->getFlashdata('errors') as $error): ?>
                <li><?= $error ?></li>
            <?php endforeach; ?>
        </ul>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="admin-card">
    <form action="<?= base_url('admin/activities/update/' . $activity['id']) ?>" method="POST" enctype="multipart/form-data">
        <?= csrf_field() ?>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="tanggal" class="form-label">Tanggal <span class="text-danger">*</span></label>
                <input type="date" class="form-control" id="tanggal" name="tanggal" 
                       value="<?= old('tanggal', $activity['tanggal']) ?>" required>
            </div>
            <div class="col-md-6 mb-3">
                <label for="jam" class="form-label">Jam <span class="text-danger">*</span></label>
                <input type="time" class="form-control" id="jam" name="jam" 
                       value="<?= old('jam', $activity['jam']) ?>" required>
            </div>
        </div>

        <div class="mb-3">
            <label for="nama_aktivitas" class="form-label">Nama Aktivitas <span class="text-danger">*</span></label>
            <input type="text" class="form-control" id="nama_aktivitas" name="nama_aktivitas" 
                   value="<?= old('nama_aktivitas', $activity['nama_aktivitas']) ?>" required>
        </div>

        <div class="mb-3">
            <label for="deskripsi" class="form-label">
                <i class="bi bi-file-text me-1"></i>Deskripsi
            </label>
            
            <textarea class="form-control" id="deskripsi" name="deskripsi" rows="5" 
                      placeholder="Tulis deskripsi atau klik Generate AI untuk membuat otomatis..."><?= old('deskripsi', $activity['deskripsi']) ?></textarea>
            
            <!-- AI Generate Button -->
            <button type="button" class="btn btn-outline-primary btn-sm position-absolute ai-generate-btn" 
                    style="top: 35px; right: 10px; z-index: 10;" 
                    id="generateDescriptionBtn" onclick="generateActivityDescription()">
                <i class="bi bi-magic" id="generateIcon"></i>
                <span id="generateText">Generate AI</span>
            </button>
            
            <!-- AI Status -->
            <div class="ai-status mt-2" id="aiStatus" style="display: none;">
                <div class="alert alert-info alert-sm">
                    <i class="bi bi-robot me-1"></i>
                    <span id="aiStatusText">Sedang menggenerate deskripsi...</span>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="foto" class="form-label">Foto</label>
                <?php if ($activity['foto']): ?>
                    <div class="mb-2">
                        <img src="<?= image_url('activities', $activity['foto'], 200, 150) ?>" 
                             alt="Foto saat ini" style="max-width: 200px; border-radius: 5px;"
                             onerror="this.src='<?= base_url('placeholder/200/150') ?>'; this.onerror=null;">
                        <p class="text-white small mt-1">Foto saat ini</p>
                    </div>
                <?php endif; ?>
                <input type="file" class="form-control" id="foto" name="foto" 
                       accept="image/jpeg,image/png,image/gif">
                <small class="text-white">Format: JPG, PNG, GIF (Max: 2MB). Kosongkan jika tidak ingin mengubah.</small>
            </div>
            <div class="col-md-6 mb-3">
                <label for="video" class="form-label">Video</label>
                <?php if ($activity['video']): ?>
                    <div class="mb-2">
                        <p class="text-white small">
                            <i class="bi bi-play-circle me-1"></i>Video saat ini tersedia
                        </p>
                    </div>
                <?php endif; ?>
                <input type="file" class="form-control" id="video" name="video" 
                       accept="video/mp4,video/avi,video/mov">
                <small class="text-white">Format: MP4, AVI, MOV (Max: 10MB). Kosongkan jika tidak ingin mengubah.</small>
            </div>
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-save me-1"></i>Update
            </button>
            <a href="<?= base_url('admin/activities') ?>" class="btn btn-secondary">
                <i class="bi bi-x me-1"></i>Batal
            </a>
        </div>
    </form>
</div>
<?= $this->endSection() ?>

<script src="<?= base_url('assets/js/ai-generator.js') ?>"></script>
<script>
// Initialize AI Generator UI for Activities Edit
document.addEventListener('DOMContentLoaded', function() {
    // Auto-fill AI input when nama_aktivitas changes
    const namaAktivitas = document.getElementById('nama_aktivitas');
    if (namaAktivitas) {
        namaAktivitas.addEventListener('input', function() {
            const aiInput = document.getElementById('aiInput');
            if (aiInput && this.value) {
                aiInput.value = `Saya melakukan aktivitas "${this.value}". Tolong buatkan deskripsi yang menarik dan profesional tentang aktivitas ini.`;
            }
        });
    }
});
</script>

